"""
* 模块名称：Msg
* 模块用途：图形化提示信息
* 模块函数：on；off
* 模块作者：Spriven
* 模块版本：V 0.0.1
* 制作日期：09.02.13
"""

import appuifw
import e32
import TopWindow
from graphics import *
import akntextutils
from sysinfo import display_pixels

app_lock = e32.Ao_lock()
width, height = display_pixels()
font=u"CombinedChinesePlain16"

class Msg:
    __module__ = __name__
    
    def __init__(self):
        self.state = 0
        self.win = TopWindow.TopWindow()
        self.win.position = (5, 5)

    def on(self,cont,title="",corner="square",shadow=0):
        try:
            cont = akntextutils.wrap_text_to_array(unicode(cont, 'utf-8'), font, (width+120))
            self.img = Image.new(((width-10), (22+17*len(cont))))
            self.img.rectangle((0, 0, (width-10), (22+17*len(cont))), fill=0xdee7ef)
            self.img.rectangle((0, 0, (width-10), 19), fill=0)
            self.img.text((5, 18), unicode(title, 'utf-8'), 0xffffff, font=font)
            line = 0
            for i in cont:
                line += 1
                self.img.text((3, (20+17*line)), i, 0, font)
            e32.ao_yield()
            e32.reset_inactivity()
            self.win.corner_type = (unicode(corner))
            self.win.size = ((width-10), (22+17*len(cont)))
            self.win.shadow = shadow
            self.win.add_image(self.img, (0, 0))
            self.win.show()
            self.state = 1
        except:
            print "Msg there is an error in the definition of the object"

    def off(self):
        if self.state == 1:
            self.win.hide()
            self.state = 0
        else: pass

if __name__ == "__main__":
    msg=Msg()
    msg.on("模块用法：\nimport Msg, time\nmsg=Msg()\nmsg.on(Content, Title, Corner, Shadow)\ntime.sleep(3)\nmsg.off()", "Msg模块 V 0.1：", "corner3", 1)
    e32.ao_sleep(5)
    msg.off()